/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.awt.Point;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomRegisters;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Zone3D;
import noppes.npcs.util.IPermission;

public class ItemBoundary
extends Item
implements IPermission {
    public ItemBoundary() {
        this.setRegistryName("customnpcs", "npcboundary");
        this.func_77655_b("npcboundary");
        this.field_77777_bU = 1;
        this.func_77637_a(CustomRegisters.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> list, @Nonnull ITooltipFlag flagIn) {
        list.add(new TextComponentTranslation("info.item.boundary", new Object[]{new TextComponentTranslation("tile.npcborder.name", new Object[0]).func_150254_d()}).func_150254_d());
        Zone3D reg = null;
        if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("RegionID", 3)) {
            reg = (Zone3D)BorderController.getInstance().getRegion(stack.func_77978_p().func_74762_e("RegionID"));
        }
        if (reg == null) {
            list.add(new TextComponentTranslation("info.item.boundary.2", new Object[0]).func_150254_d());
            list.add(new TextComponentTranslation("info.item.boundary.3", new Object[0]).func_150254_d());
            return;
        }
        for (int i = 0; i < 4; ++i) {
            list.add(new TextComponentTranslation("info.item.boundary." + i, new Object[0]).func_150254_d());
        }
        list.add(new TextComponentTranslation("info.item.boundary.4", new Object[]{"" + reg.getId(), reg.name}).func_150254_d());
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.TeleportTo || e == EnumPacketServer.RegionData;
    }

    public void leftClick(ItemStack stack, EntityPlayerMP player) {
        PlayerData data = PlayerData.get((EntityPlayer)player);
        if (data == null) {
            return;
        }
        int id = -1;
        Vec3d vec3d = player.func_174824_e(1.0f);
        Vec3d vec3d2 = player.func_70676_i(1.0f);
        Vec3d vec3d3 = vec3d.func_72441_c(vec3d2.field_72450_a * 5.0, vec3d2.field_72448_b * 5.0, vec3d2.field_72449_c * 5.0);
        RayTraceResult result = player.field_70170_p.func_147447_a(vec3d, vec3d3, false, false, false);
        BlockPos pos = null;
        if (result != null) {
            int x = result.func_178782_a().func_177958_n();
            int y = result.func_178782_a().func_177956_o();
            int z = result.func_178782_a().func_177952_p();
            try {
                switch (result.field_178784_b) {
                    case UP: {
                        ++y;
                        break;
                    }
                    case NORTH: {
                        --z;
                        break;
                    }
                    case SOUTH: {
                        ++z;
                        break;
                    }
                    case WEST: {
                        --x;
                        break;
                    }
                    case EAST: {
                        ++x;
                        break;
                    }
                    default: {
                        --y;
                        break;
                    }
                }
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            pos = new BlockPos(x, y, z);
        }
        if (pos == null) {
            return;
        }
        BorderController bData = BorderController.getInstance();
        if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("RegionID", 3)) {
            id = stack.func_77978_p().func_74762_e("RegionID");
        }
        if (data.hud.hasOrKeysPressed(42, 54)) {
            Zone3D reg = bData.createNew(player.field_70170_p.field_73011_w.getDimension(), pos);
            bData.save();
            bData.update(reg.getId());
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.BoundarySetting, null, reg.getId(), 0, 0);
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
                stack.func_77982_d(compound);
            }
            compound.func_74768_a("RegionID", reg.getId());
            return;
        }
        Zone3D reg = (Zone3D)bData.getRegion(id);
        if (reg == null) {
            return;
        }
        Point p = reg.points.get(reg.getIdNearestPoint(player.func_180425_c()));
        if (p == null || !reg.contains(p.x, p.y)) {
            return;
        }
        boolean remove = reg.removePoint(p.x, p.y);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.boundary.del.vertex." + remove, new Object[]{"" + p.x, "" + p.y, reg.toString()}));
        if (remove) {
            reg.fix();
            bData.save();
            bData.update(id);
        }
    }

    public void rightClick(ItemStack stack, EntityPlayerMP player) {
        Zone3D reg;
        PlayerData data = PlayerData.get((EntityPlayer)player);
        if (data == null) {
            return;
        }
        int id = -1;
        BorderController bData = BorderController.getInstance();
        Vec3d vec3d = player.func_174824_e(1.0f);
        Vec3d vec3d2 = player.func_70676_i(1.0f);
        Vec3d vec3d3 = vec3d.func_72441_c(vec3d2.field_72450_a * 5.0, vec3d2.field_72448_b * 5.0, vec3d2.field_72449_c * 5.0);
        RayTraceResult result = player.field_70170_p.func_147447_a(vec3d, vec3d3, false, false, false);
        BlockPos pos = null;
        if (result != null) {
            int x = result.func_178782_a().func_177958_n();
            int y = result.func_178782_a().func_177956_o();
            int z = result.func_178782_a().func_177952_p();
            try {
                switch (result.field_178784_b) {
                    case UP: {
                        ++y;
                        break;
                    }
                    case NORTH: {
                        --z;
                        break;
                    }
                    case SOUTH: {
                        ++z;
                        break;
                    }
                    case WEST: {
                        --x;
                        break;
                    }
                    case EAST: {
                        ++x;
                        break;
                    }
                    default: {
                        --y;
                        break;
                    }
                }
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            pos = new BlockPos(x, y, z);
        }
        if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("RegionID", 3)) {
            id = stack.func_77978_p().func_74762_e("RegionID");
        }
        if ((reg = (Zone3D)bData.getRegion(id)) == null || data.hud.hasOrKeysPressed(42, 54)) {
            if (reg != null && pos == null) {
                pos = player.func_180425_c();
            }
            if (!bData.regions.isEmpty()) {
                NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.BoundarySetting, null, id, reg == null ? -1 : reg.getIdNearestPoint(pos), 0);
            }
            return;
        }
        if (pos != null) {
            boolean add = false;
            if (reg.contains(pos.func_177958_n(), pos.func_177952_p())) {
                int max;
                int min = Math.abs(reg.y[0] - pos.func_177956_o());
                if (min <= (max = Math.abs(reg.y[1] - pos.func_177956_o()))) {
                    reg.y[0] = pos.func_177956_o();
                } else {
                    reg.y[1] = pos.func_177956_o();
                    add = true;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.boundary.offset.y." + add, new Object[]{"" + pos.func_177958_n(), "" + pos.func_177956_o(), "" + pos.func_177952_p(), reg.toString()}));
                add = true;
            } else {
                add = reg.insertPoint(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Objects.requireNonNull(NpcAPI.Instance()).getIPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.boundary.add.vertex." + add, new Object[]{"" + pos.func_177958_n(), "" + pos.func_177956_o(), "" + pos.func_177952_p(), reg.toString()}));
            }
            if (add) {
                reg.fix();
                bData.save();
                bData.update(reg.getId());
            }
        }
    }
}

